<?php

namespace App\Models\Stock;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Stock extends Model 
{

    protected $table = 'stock';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function location()
    {
        return $this->belongsTo('App\Models\Company\Location', 'location_id');
    }

    public function product_abstraction()
    {
        return $this->belongsTo('App\Models\Product\ProductAbstraction', 'product_abstraction_id');
    }

}